/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.brewingstand.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.jetbrains.annotations.Nullable;

@Name(value="Brewing - Remaining Time/Ticks")
@Description(value={"Returns the brewing time of a Brewing Stand (the time before the brewing is over, 0 seconds = finished, 20 seconds = just started. Can be set to a longer time, progress won't be displayed until it reaches 20 seconds).\nCan be set."})
@Examples(value={"on brewing start:\n\tbroadcast the brewing time of event-block"})
@Since(value={"1.0.2, 1.3 (Plural, Blockstate, Item, Ticks)"})
public class ExprBrewingTime
extends SimplerPropertyExpression<Object, Object> {
    private boolean usesTicks;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.usesTicks = parseResult.hasTag("ticks");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Object convert(Object from) {
        Integer ticks = new BlockWrapper(from).getBrewingTime();
        if (ticks == null) {
            return null;
        }
        if (this.usesTicks) {
            return ticks;
        }
        return CompatibilityUtils.fromTicks(ticks.intValue());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Timespan.class;
            classArray = classArray2;
            classArray2[1] = Integer.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    @Override
    public void set(Object from, Object to) {
        if (to instanceof Integer) {
            Integer integer = (Integer)to;
            new BlockWrapper(from, true).setBrewingTime(integer);
        } else if (to instanceof Timespan) {
            Timespan timespan = (Timespan)to;
            new BlockWrapper(from, true).setBrewingTime((int)CompatibilityUtils.getTicks(timespan));
        }
    }

    protected String getPropertyName() {
        return "remaining brewing " + (this.usesTicks ? "ticks" : "time");
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    static {
        ExprBrewingTime.register(ExprBrewingTime.class, Object.class, (String)"[remaining] brewing (time[span]|:ticks)", (String)"blocks/blockstates/itemtypes");
    }
}

