/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.composter.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.block.CompostItemEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Cancel Composter Level Rise")
@Description(value={"This Effect requires Paper.\n\nCan only be used in a Compost Item Event.\nSets whether or not the composter's level should rise."})
@Examples(value={"on hopper compost:\n  cancel composter level rise"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class EffCancelComposterRising
extends Effect {
    private boolean uncancel;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(CompostItemEvent.class)) {
            Skript.error((String)"This effect can only be used in the Compost Item Event!");
            return false;
        }
        this.uncancel = parser.hasTag("un");
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (this.uncancel ? "un" : "") + "cancel the composter level raise";
    }

    protected void execute(@NotNull Event event) {
        ((CompostItemEvent)event).setWillRaiseLevel(this.uncancel);
    }

    static {
        Skript.registerEffect(EffCancelComposterRising.class, (String[])new String[]{"[:un]cancel [the] composter [level] rise"});
    }
}

