/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.furnace.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;

public class EvtFurnaceEvents {
    static {
        if (Skript.classExists((String)"org.bukkit.event.inventory.FurnaceExtractEvent")) {
            Skript.registerEvent((String)"Furnace - on Item Extract", SimpleEvent.class, FurnaceExtractEvent.class, (String[])new String[]{"furnace [item] extract[ed|ing]"}).description(new String[]{"This event is called when a player takes items out of the furnace.\n\nevent-integer -> item amount being retrieved\n"}).examples(new String[]{""}).since("1.0.1");
            CompatibilityUtils.registerEventValue(FurnaceExtractEvent.class, Slot.class, e -> new InventorySlot(e.getPlayer().getOpenInventory().getTopInventory(), 2), 0);
            CompatibilityUtils.registerEventValue(FurnaceExtractEvent.class, ItemType.class, e -> new ItemType(e.getItemType()), 0);
            CompatibilityUtils.registerEventValue(FurnaceExtractEvent.class, Integer.class, FurnaceExtractEvent::getItemAmount, 0);
        }
        if (Skript.classExists((String)"org.bukkit.event.inventory.FurnaceStartSmeltEvent")) {
            Skript.registerEvent((String)"Furnace - on Start Smelting", SimpleEvent.class, FurnaceStartSmeltEvent.class, (String[])new String[]{"furnace start[ed|ing] [to] smelt[ed|ing]", "furnace smelt[ed|ing] start[ed|ing]"}).description(new String[]{"Called when a Furnace starts smelting, or cooking for that matter."}).examples(new String[]{"on furnace start smelting:\n  uncancel the event\n  broadcast \"<bold>let him cook!\"\n"}).since("1.0.1");
            CompatibilityUtils.registerEventValue(FurnaceStartSmeltEvent.class, Integer.class, FurnaceStartSmeltEvent::getTotalCookTime, 0);
        }
    }
}

