/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.hopper.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Hopper - Searched Block")
@Description(value={"Searched Block expression for the Hopper Inventory Search Event."})
@Examples(value={"on inventory search:\n\tbroadcast the searched block"})
@Since(value={"1.0.4"})
public class ExprHopperSearchedBlock
extends SimpleExpression<Block> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(HopperInventorySearchEvent.class)) {
            Skript.error((String)"This expression can only be used in the Hopper Inventory Search Event!");
            return false;
        }
        return true;
    }

    protected Block @NotNull [] get(@NotNull Event e) {
        return new Block[]{((HopperInventorySearchEvent)e).getSearchBlock()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the searched block";
    }

    static {
        if (Constants.HAS_HOPPER_INVENTORY_SEARCH_EVENT) {
            Skript.registerExpression(ExprHopperSearchedBlock.class, Block.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] searched block"});
        }
    }
}

