/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.jukebox.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.BlockWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Jukebox - Eject Disc")
@Description(value={"Forces a jukebox to eject its disc."})
@Examples(value={"eject the music disc of target block"})
@Since(value={"1.0.3, 1.3 (Blockstate)"})
@DocumentationId(value="9131")
public class EffJukeboxEject
extends Effect {
    private Expression<Object> objectExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.objectExpression = expressions[0];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "eject the music disc of " + this.objectExpression.toString(event, debug);
    }

    protected void execute(@NotNull Event event) {
        for (Object o : this.objectExpression.getAll(event)) {
            new BlockWrapper(o).ejectJukeboxDisc();
        }
    }

    static {
        Skript.registerEffect(EffJukeboxEject.class, (String[])new String[]{"eject [the] [music] (disc|record) (of|from) %blocks/blockstates%", "eject %blocks/blockstates%'[s] [music] (disc|record)"});
    }
}

