/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.jukebox.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.BlockWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Jukebox - Start/Stop Playing")
@Description(value={"Makes a jukebox start/stop playing."})
@Examples(value={"make target block start playing"})
@Since(value={"1.0.3, 1.3 (Blockstate)"})
@DocumentationId(value="9132")
public class EffJukeboxPlay
extends Effect {
    private Expression<Object> objectExpression;
    private boolean stop;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.objectExpression = expressions[0];
        this.stop = parser.hasTag("stop");
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "make " + this.objectExpression.toString(event, debug) + (this.stop ? " stop" : " start") + " playing";
    }

    protected void execute(@NotNull Event event) {
        for (Object o : this.objectExpression.getAll(event)) {
            BlockWrapper block = new BlockWrapper(o);
            if (this.stop) {
                block.stopPlayingJukebox();
                continue;
            }
            block.startPlayingJukebox();
        }
    }

    static {
        Skript.registerEffect(EffJukeboxPlay.class, (String[])new String[]{"make %blocks/blockstates% (:stop|start) playing", "make %blocks/blockstates% stop playing"});
    }
}

