/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.jukebox.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.jetbrains.annotations.Nullable;

@Name(value="Jukebox - Record/Disc")
@Description(value={"Returns the music disc within a jukebox.\nCan be set, reset and deleted."})
@Examples(value={"broadcast the music disc of {_j}"})
@Since(value={"1.0.3, 1.3 (Plural, Blockstate)"})
@DocumentationId(value="9162")
public class ExprJukeboxRecord
extends SimplerPropertyExpression<Object, ItemType> {
    @Nullable
    public ItemType convert(Object from) {
        return new BlockWrapper(from).getJukeboxRecord();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(Object from, ItemType to) {
        new BlockWrapper(from, true).setJukeboxRecord(to);
    }

    @Override
    public void delete(Object from) {
        this.set(from, null);
    }

    @Override
    public void reset(Object from) {
        this.delete(from);
    }

    protected String getPropertyName() {
        return "jukebox music record";
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    static {
        ExprJukeboxRecord.register(ExprJukeboxRecord.class, ItemType.class, (String)"[jukebox] [music] (disc|record)", (String)"blocks/blockstates/itemtypes");
    }
}

