/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.lectern.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import io.papermc.paper.event.player.PlayerLecternPageChangeEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtLecternPageChange
extends SkriptEvent {
    private PlayerLecternPageChangeEvent.PageChangeDirection action;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.action = PlayerLecternPageChangeEvent.PageChangeDirection.LEFT;
        } else if (matchedPattern == 1) {
            this.action = PlayerLecternPageChangeEvent.PageChangeDirection.RIGHT;
        }
        return true;
    }

    public boolean check(@NotNull Event e) {
        if (this.action == null) {
            return true;
        }
        return this.action == ((PlayerLecternPageChangeEvent)e).getPageChangeDirection();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "lectern page flip" + (String)(this.action == null ? "" : " to the " + this.action.toString().toLowerCase());
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerLecternPageChangeEvent")) {
            Skript.registerEvent((String)"Lectern - on Page Flip", EvtLecternPageChange.class, PlayerLecternPageChangeEvent.class, (String[])new String[]{"lectern page flip[ping|ped] [to[wards] the] left", "lectern page flip[ping|ped] [to[wards] the] right", "lectern page flip[ping|ped] [(in|to[wards]) either direction|on either side]"}).description(new String[]{"Called when a player flips the page in a Lectern."}).examples(new String[]{"on lectern page flip to the right:\n  broadcast \"right\"\n\non lectern page flip to the left:\n  broadcast \"left\"\n\non lectern page flip:\n  broadcast \"either\"\n"}).since("1.0.0").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(PlayerLecternPageChangeEvent.class, ItemStack.class, PlayerLecternPageChangeEvent::getBook, 0);
            CompatibilityUtils.registerEventValue(PlayerLecternPageChangeEvent.class, Block.class, e -> e.getLectern().getBlock(), 0);
        }
    }
}

