/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.loom.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import io.papermc.paper.event.player.PlayerLoomPatternSelectEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import java.util.Arrays;
import org.bukkit.block.banner.PatternType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtLoomPatternSelect
extends SkriptEvent {
    @Nullable
    private PatternType[] types = new PatternType[0];

    public boolean init(Literal @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        if (args.length > 0) {
            this.types = args[0] == null ? null : (PatternType[])args[0].getAll();
        }
        return true;
    }

    public boolean check(@NotNull Event e) {
        if (this.types == null) {
            return true;
        }
        @NotNull PatternType patternType = ((PlayerLoomPatternSelectEvent)e).getPatternType();
        for (PatternType type : this.types) {
            if (type != patternType) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "loom pattern select" + (String)(this.types == null ? "" : " of " + Arrays.toString(this.types));
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerLoomPatternSelectEvent")) {
            Skript.registerEvent((String)"Loom - on Pattern Select", EvtLoomPatternSelect.class, PlayerLoomPatternSelectEvent.class, (String[])new String[]{"[loom] pattern select [of %-bannerpatterntypes%]"}).description(new String[]{"This Event requires Paper.\n\nCalled when a player selects a banner pattern in a loom inventory."}).examples(new String[]{"on pattern select of border:\n  set pattern to creeper\n\non pattern select:\n  broadcast event-patterntype\n\non pattern select of bricks:\n  broadcast the selected pattern\n"}).requiredPlugins(new String[]{"Paper"}).since("1.0.0");
            CompatibilityUtils.registerEventValue(PlayerLoomPatternSelectEvent.class, PatternType.class, PlayerLoomPatternSelectEvent::getPatternType, 0);
        }
    }
}

