/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.sign.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.jetbrains.annotations.Nullable;

@Name(value="Sign - is Editable (Property)")
@Description(value={"Returns whether or not the provided signs are editable.\nCan be set and reset (which makes it editable)."})
@Examples(value={"broadcast editable property of target block"})
@Since(value={"1.0.3, 1.3 (Plural, Blockstate, Items)"})
@DocumentationId(value="9166")
public class ExprSignIsEditable
extends SimpleBooleanPropertyExpression<Object> {
    @Nullable
    public Boolean convert(Object from) {
        return new BlockWrapper(from).isSignEditable();
    }

    @Override
    public void set(Object from, Boolean to) {
        new BlockWrapper(from).setIsSignEditable(to);
    }

    @Override
    public void reset(Object from) {
        this.set(from, (Boolean)true);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "is editable";
    }

    static {
        ExprSignIsEditable.register(ExprSignIsEditable.class, Boolean.class, "[sign]", "[is] editable", "blocks/blockstates/itemtypes");
    }
}

