/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.sign.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.jetbrains.annotations.Nullable;

@Name(value="Sign - is Waxed (Property)")
@Description(value={"Returns whether or not the provided signs are waxed.\nCan be set and reset (which makes it not waxed)."})
@Examples(value={"broadcast editable state of target block"})
@Since(value={"1.3"})
@RequiredPlugins(value={"1.20.1+"})
public class ExprSignIsWaxed
extends SimpleBooleanPropertyExpression<Object> {
    @Nullable
    public Boolean convert(Object from) {
        return new BlockWrapper(from).isSignWaxed();
    }

    @Override
    public void set(Object from, Boolean to) {
        new BlockWrapper(from, true).setIsSignWaxed(to);
    }

    @Override
    public void reset(Object from) {
        this.set(from, (Boolean)true);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "is waxed";
    }

    static {
        if (Constants.MINECRAFT_1_20_1) {
            ExprSignIsWaxed.register(ExprSignIsWaxed.class, Boolean.class, "[sign]", "[is] waxed", "blocks/blockstates/itemtypes");
        }
    }
}

