/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.spawner.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawner/Trial Spawner - Entity Type")
@Description(value={"Gets the spawner entity type of the provided spawners or trial spawners (1.21+).\n\n**Works with Items.**\n**Works with Spawner Minecarts (Requires 1.20+).**\n\nCan be set, reset (sets it to pig), and deleted (requires Minecraft 1.20+).\n"})
@Examples(value={"set spawner entity type of {_block} to zombie"})
@Since(value={"1.3.4"})
public class ExprSpawnerEntityType
extends SimplerPropertyExpression<Object, EntityData> {
    @Nullable
    public EntityData convert(Object from) {
        return new BlockWrapper(from).getSpawnerEntityType();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return Constants.MINECRAFT_1_20;
    }

    @Override
    public void delete(Object from) {
        super.delete(from);
    }

    @Override
    public void set(Object from, EntityData to) {
        new BlockWrapper(from, true).setSpawnerEntityType(to);
    }

    @Override
    public void reset(Object from) {
        new BlockWrapper(from, true).setSpawnerEntityType(EntityType.PIG);
    }

    protected String getPropertyName() {
        return "spawner entity type";
    }

    public Class<? extends EntityData> getReturnType() {
        return EntityData.class;
    }

    static {
        ExprSpawnerEntityType.register(ExprSpawnerEntityType.class, EntityData.class, (String)"spawner (entity|creature) type", (String)("itemtypes/blocks/blockstates" + (Constants.MINECRAFT_1_20 ? "/entities" : "")));
    }
}

