/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.AABB;
import ch.njol.util.Kleenean;
import com.google.common.collect.Lists;
import java.util.Iterator;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - Blocks Within")
@Description(value={"Gets all the blocks within a bounding box in a specific world."})
@Examples(value={"broadcast blocks within box {_box} in {_world}"})
@Since(value={"1.3"})
public class ExprBoundingBoxBlocks
extends SimpleExpression<Block> {
    private Expression<BoundingBox> boundingBoxExpression;
    private Expression<World> worldExpression;

    public boolean init(Expression<?>[] vars, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.boundingBoxExpression = vars[0];
        this.worldExpression = vars[1];
        return true;
    }

    protected Block @NotNull [] get(@NotNull Event event) {
        return (Block[])this.worldExpression.stream(event).flatMap(world -> this.boundingBoxExpression.stream(event).flatMap(boundingBox -> Lists.newArrayList((Iterator)new AABB(boundingBox.getMin().toLocation(world), boundingBox.getMax().toLocation(world)).iterator()).stream())).toArray(Block[]::new);
    }

    @NotNull
    public Class<Block> getReturnType() {
        return Block.class;
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "all of the blocks within bounding boxes " + this.boundingBoxExpression.toString(event, debug) + " in worlds " + this.worldExpression.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBoundingBoxBlocks.class, Block.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[all [[of] the]|the] blocks within [bounding[ ]]box[es] %boundingboxes% in [world[s]] %worlds%"});
    }
}

