/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.function.Predicate;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - Entities Within")
@Description(value={"Gets all the entities within a bounding box in a specific world."})
@Examples(value={"broadcast entities within box {_box} in {_world}"})
@Since(value={"1.3"})
public class ExprBoundingBoxEntities
extends SimpleExpression<Entity> {
    private Expression<EntityData<?>> entityDataExpression;
    private Expression<BoundingBox> boundingBoxExpression;
    private Expression<World> worldExpression;

    public boolean init(Expression<?>[] vars, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.entityDataExpression = vars[0];
        this.boundingBoxExpression = vars[1];
        this.worldExpression = vars[2];
        return true;
    }

    protected Entity @NotNull [] get(@NotNull Event event) {
        return (Entity[])this.boundingBoxExpression.stream(event).flatMap(boundingBox -> this.entityDataExpression.stream(event).flatMap(entityData -> {
            Class entityClass = entityData.getType();
            Predicate<Entity> filter = entity -> entityClass.isAssignableFrom(entity.getClass());
            return this.worldExpression.stream(event).flatMap(world -> world.getNearbyEntities(boundingBox, filter).stream());
        })).toArray(Entity[]::new);
    }

    @NotNull
    public Class<Entity> getReturnType() {
        return Entity.class;
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "all of the " + this.entityDataExpression.toString(event, debug) + " within bounding boxes " + this.boundingBoxExpression.toString(event, debug) + " in world " + this.worldExpression.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBoundingBoxEntities.class, Entity.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[all [[of] the]|the] %*entitydatas% (of|in|within) [bounding[ ]]box[es] %boundingboxes% in [world[s]] %worlds%"});
    }
}

