/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import org.bukkit.Axis;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bounding Box - Height and Width X/Z")
@Description(value={"Gets the height, X width and Z width of 1 or more bounding boxes."})
@Examples(value={"broadcast box height of bounding box of target"})
@Since(value={"1.2.1"})
public class ExprBoundingBoxMeasurements
extends PropertyExpression<BoundingBox, Double> {
    Axis coordinate;

    public boolean init(Expression<?>[] vars, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        this.coordinate = parser.hasTag("x") ? Axis.X : (parser.hasTag("z") ? Axis.Z : Axis.Y);
        return true;
    }

    @NotNull
    public Class<Double> getReturnType() {
        return Double.class;
    }

    protected Double @NotNull [] get(@NotNull Event e, BoundingBox @NotNull [] source) {
        return (Double[])this.get(source, box -> switch (this.coordinate) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> box.getWidthX();
            case Axis.Y -> box.getHeight();
            case Axis.Z -> box.getWidthZ();
        });
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "bounding box " + (String)(this.coordinate == Axis.Y ? "height " : (this.coordinate == Axis.X ? "x" : "z") + " width ") + this.getExpr().toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBoundingBoxMeasurements.class, Double.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [bounding[ ]]box ((:x|:z) width|height) of %boundingboxes%", "%boundingboxes%'[s] [bounding[ ]]box ((:x|:z) width|height)"});
    }
}

