/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.boundingbox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.block.Block;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Voxel Shape - of Block")
@Description(value={"Returns the detailed collision shape of a block."})
@Examples(value={"broadcast voxel shape of target block"})
@Since(value={"1.2"})
@RequiredPlugins(value={"1.17"})
public class ExprVoxelShapeOf
extends SimplePropertyExpression<Block, VoxelShape> {
    @Nullable
    public VoxelShape convert(Block from) {
        return from.getCollisionShape();
    }

    @NotNull
    protected String getPropertyName() {
        return "voxel shape";
    }

    @NotNull
    public Class<? extends VoxelShape> getReturnType() {
        return VoxelShape.class;
    }

    static {
        if (Constants.HAS_VOXEL_SHAPE) {
            ExprVoxelShapeOf.register(ExprVoxelShapeOf.class, VoxelShape.class, (String)"(voxel|collision) shape", (String)"blocks");
        }
    }
}

