/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.enchantment.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enchantment - Maximum Level")
@Description(value={"Returns the Maximum Vanilla Level for an Enchantment."})
@Examples(value={"broadcast max level of sharpness"})
@Since(value={"1.0.0"})
public class ExprMaxEnchantLevel
extends SimplePropertyExpression<Enchantment, Integer> {
    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Nullable
    public Integer convert(Enchantment enchantment) {
        return enchantment.getMaxLevel();
    }

    @NotNull
    protected String getPropertyName() {
        return "vanilla maximum enchantment level";
    }

    static {
        ExprMaxEnchantLevel.register(ExprMaxEnchantLevel.class, Integer.class, (String)"[vanilla] max[imum] enchant[ment] level", (String)"enchantments");
    }
}

