/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.allay.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Allay - can Be Duplication (Property)")
@Description(value={"Returns whether or not the allay can duplicate itself.\nCan be set."})
@Examples(value={"broadcast duplication state of target"})
@Since(value={"1.0.2, 1.3 (Plural)"})
@DocumentationId(value="9054")
public class ExprAllayCanBeDuplicated
extends SimpleBooleanPropertyExpression<Entity> {
    @Nullable
    public Boolean convert(Entity from) {
        Allay allay;
        return from instanceof Allay && (allay = (Allay)from).canDuplicate();
    }

    @Override
    public void set(Entity from, Boolean to) {
        if (from instanceof Allay) {
            Allay allay = (Allay)from;
            allay.setCanDuplicate(to.booleanValue());
        }
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "can be duplicated";
    }

    static {
        ExprAllayCanBeDuplicated.register(ExprAllayCanBeDuplicated.class, Boolean.class, "[allay]", "(can be duplicated|duplication)", "livingentities");
    }
}

