/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.allay.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.block.Block;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Allay - Jukebox")
@Description(value={"Gets the jukebox the allay is set to dance to."})
@Examples(value={"broadcast jukebox of target"})
@Since(value={"1.0.2"})
public class ExprAllayJukebox
extends SimplePropertyExpression<Entity, Block> {
    @NotNull
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Nullable
    public Block convert(Entity e) {
        Allay allay;
        return e instanceof Allay && (allay = (Allay)e).getJukebox() != null ? allay.getJukebox().getBlock() : null;
    }

    @NotNull
    protected String getPropertyName() {
        return "jukebox";
    }

    static {
        ExprAllayJukebox.register(ExprAllayJukebox.class, Block.class, (String)"jukebox", (String)"entities");
    }
}

