/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armadillo.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Armadillo - roll Out/Up")
@Description(value={"Attempts to roll the provided armadillos up (if they're idle) or out (if they're not idle).\n"})
@Examples(value={"make target roll up"})
@Since(value={"1.3.8"})
@RequiredPlugins(value={"1.21.5"})
public class EffArmadilloRoll
extends Effect {
    private Expression<LivingEntity> entityExpression;
    private boolean out;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = expressions[0];
        this.out = matchedPattern == 1;
        return true;
    }

    protected void execute(Event event) {
        for (LivingEntity livingEntity : (LivingEntity[])this.entityExpression.getAll(event)) {
            if (!(livingEntity instanceof Armadillo)) continue;
            Armadillo armadillo = (Armadillo)livingEntity;
            if (this.out) {
                armadillo.rollOut();
                continue;
            }
            armadillo.rollUp();
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "make armadillos " + this.entityExpression.toString(event, debug) + " roll " + (this.out ? "out" : "up");
    }

    static {
        Skript.registerEffect(EffArmadilloRoll.class, (String[])new String[]{"make [armadillo[s]] %livingentities% roll (up|in)", "make [armadillo[s]] %livingentities% roll out"});
    }
}

