/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armadillo.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Armadillo - State")
@Description(value={"Gets the State of one or more Armadillos, cannot be set."})
@Examples(value={"set {_state} to armadillo state of {_armadillo}"})
@Since(value={"1.3.8"})
@RequiredPlugins(value={"1.21.5+"})
public class ExprArmadilloState
extends SimplerPropertyExpression<LivingEntity, Armadillo.State> {
    @Nullable
    public Armadillo.State convert(LivingEntity from) {
        Armadillo.State state;
        if (from instanceof Armadillo) {
            Armadillo armadillo = (Armadillo)from;
            state = armadillo.getState();
        } else {
            state = null;
        }
        return state;
    }

    protected String getPropertyName() {
        return "armadillo state";
    }

    public Class<? extends Armadillo.State> getReturnType() {
        return Armadillo.State.class;
    }

    static {
        if (Constants.MINECRAFT_1_21_5) {
            ExprArmadilloState.register(ExprArmadilloState.class, Armadillo.State.class, (String)"armadillo state", (String)"livingentities");
        }
    }
}

