/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;

@Name(value="Armor Stand - can Tick (Property)")
@Description(value={"Gets and sets the `canTick` property of an armorstand entity or item.\n\nUnlike other Armorstand properties, this one cannot be used on the armorstand item as of 1.21.3.\n"})
@Examples(value={"set can tick property of target to true", "set can tick state of target to false"})
@Since(value={"1.0.2"})
public class ExprArmorStandCanTick
extends SimpleBooleanPropertyExpression<LivingEntity> {
    public Boolean convert(LivingEntity from) {
        if (from instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)from;
            return armorStand.canTick();
        }
        return false;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)from;
            armorStand.setCanTick(to.booleanValue());
        }
    }

    protected String getPropertyName() {
        return "armor stand can tick property";
    }

    static {
        ExprArmorStandCanTick.register(ExprArmorStandCanTick.class, Boolean.class, "[armor[ |-]stand]", "[can] tick", "livingentities");
    }
}

