/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - Disabled Slots")
@Description(value={"All the disabled slots of an armor stand.\nCan be set, remove from, added to, reset and deleted."})
@Examples(value={"add chest slot to disabled slots of {_armorStand}"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Skript 2.7+"})
public class ExprArmorStandDisabledSlots
extends PropertyExpression<LivingEntity, EquipmentSlot> {
    protected EquipmentSlot[] get(Event event, LivingEntity[] source) {
        return (EquipmentSlot[])Arrays.stream(source).filter(ArmorStand.class::isInstance).map(ArmorStand.class::cast).flatMap(armorStand -> armorStand.getDisabledSlots().stream()).toArray(EquipmentSlot[]::new);
    }

    public Class<? extends EquipmentSlot> getReturnType() {
        return EquipmentSlot.class;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "armor stand disabled equipment slots of " + this.getExpr().toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        return true;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Stream<ArmorStand> armorStands = this.getExpr().stream(event).filter(ArmorStand.class::isInstance).map(ArmorStand.class::cast);
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: {
                if (delta == null || delta.length <= 0) break;
                EquipmentSlot[] slots = (EquipmentSlot[])delta;
                armorStands.forEach(armorStand -> {
                    switch (mode) {
                        case SET: {
                            armorStand.setDisabledSlots(slots);
                            break;
                        }
                        case ADD: {
                            armorStand.addDisabledSlots(slots);
                            break;
                        }
                        case REMOVE: {
                            armorStand.removeDisabledSlots(slots);
                        }
                    }
                });
                break;
            }
            case RESET: 
            case DELETE: {
                armorStands.forEach(rec$ -> ((ArmorStand)rec$).setDisabledSlots(new EquipmentSlot[0]));
            }
        }
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{EquipmentSlot[].class});
            case Changer.ChangeMode.RESET, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    static {
        ExprArmorStandDisabledSlots.register(ExprArmorStandDisabledSlots.class, EquipmentSlot.class, "[armor[ |-]stand] disabled [equipment] slots", "livingentities");
    }
}

