/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.ArmorStandUtils;
import it.jakegblp.lusk.utils.Constants;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - has Arms (Property)")
@Description(value={"Gets and sets the `hasHarms` property of an armorstand entity or item, to do so with an armorstand item you must be using Paper.\n"})
@Examples(value={"set has arms property of target to true", "set has arms state of target to false"})
@Since(value={"1.0.2, 1.3 (Item)"})
public class ExprArmorStandHasArms
extends SimpleBooleanPropertyExpression<Object> {
    @Override
    public boolean setNegated(int matchedPattern, SkriptParser.ParseResult parseResult) {
        return parseResult.hasTag("in");
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public void set(Object from, Boolean to) {
        ArmorStandUtils.setHasArms(from, to);
    }

    @Override
    public void reset(Object from) {
        ArmorStandUtils.setHasArms(from, false);
    }

    @Nullable
    public Boolean convert(Object from) {
        return this.isNegated() ^ ArmorStandUtils.hasArms(from);
    }

    protected String getPropertyName() {
        return "armor stand arms " + (this.isNegated() ? "in" : "") + "visibility property";
    }

    static {
        ExprArmorStandHasArms.register(ExprArmorStandHasArms.class, Boolean.class, "[armor[ |-]stand]", "((have|has|show[s]) [its|their] arms|[have|has] arms [:in]visibility)", Constants.ARMOR_STAND_TYPES);
    }
}

