/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.ArmorStandUtils;
import it.jakegblp.lusk.utils.Constants;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - is Invisible (Property)")
@Description(value={"Gets and sets the `Invisible` property of an armorstand entity or item, to do so with an armorstand item you must be using Paper.\n"})
@Examples(value={"set invisibility property of target to true", "set is visible property of target to false"})
@Since(value={"1.3"})
public class ExprArmorStandIsInvisible
extends SimpleBooleanPropertyExpression<Object> {
    @Override
    public boolean setNegated(int matchedPattern, SkriptParser.ParseResult parseResult) {
        return parseResult.hasTag("in");
    }

    @Override
    public void set(Object from, Boolean to) {
        ArmorStandUtils.setIsInvisible(from, to == false);
    }

    @Override
    public void reset(Object from) {
        ArmorStandUtils.setIsInvisible(from, false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Nullable
    public Boolean convert(Object from) {
        return ArmorStandUtils.isInvisible(from) ^ !this.isNegated();
    }

    protected String getPropertyName() {
        return "armor stand is " + (this.isNegated() ? "in" : "") + "visible property";
    }

    static {
        ExprArmorStandIsInvisible.register(ExprArmorStandIsInvisible.class, Boolean.class, "[armor[ |-]stand]", "([is] [:in]visible|[:in]visibility)", Constants.ARMOR_STAND_TYPES);
    }
}

