/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.ArmorStandUtils;
import it.jakegblp.lusk.utils.Constants;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - is Marker (Property)")
@Description(value={"Gets and sets the `marker` property of an armorstand entity or item, to do so with an armorstand item you must have Paper.\n"})
@Examples(value={"set marker of target to true"})
@Since(value={"1.0.2, 1.3 (Item)"})
public class ExprArmorStandIsMarker
extends SimpleBooleanPropertyExpression<Object> {
    @Override
    public void set(Object from, Boolean to) {
        ArmorStandUtils.setIsMarker(from, to);
    }

    @Override
    public void reset(Object from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Nullable
    public Boolean convert(Object from) {
        return ArmorStandUtils.isMarker(from);
    }

    protected String getPropertyName() {
        return "armor stand is marker property";
    }

    static {
        ExprArmorStandIsMarker.register(ExprArmorStandIsMarker.class, Boolean.class, "[armor[ |-]stand]", "[is] marker", Constants.ARMOR_STAND_TYPES);
    }
}

