/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.ArmorStandUtils;
import it.jakegblp.lusk.utils.Constants;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - is Small (Property)")
@Description(value={"Gets and sets the `small` property of an armorstand entity or item, to do so with an armorstand item you must have Paper.\n"})
@Examples(value={"set small property of target to true"})
@Since(value={"1.0.2, 1.3 (Item)"})
@DocumentationId(value="9059")
public class ExprArmorStandIsSmall
extends SimpleBooleanPropertyExpression<Object> {
    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public void set(Object from, Boolean to) {
        ArmorStandUtils.setIsSmall(from, to);
    }

    @Override
    public void reset(Object from) {
        this.set(from, (Boolean)false);
    }

    @Nullable
    public Boolean convert(Object from) {
        return ArmorStandUtils.isSmall(from);
    }

    protected String getPropertyName() {
        return "armor stand is small property";
    }

    static {
        ExprArmorStandIsSmall.register(ExprArmorStandIsSmall.class, Boolean.class, "[armor[ |-]stand]", "[is] small", Constants.ARMOR_STAND_TYPES);
    }
}

