/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.bucketable.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import io.papermc.paper.entity.Bucketable;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Bucketable - is From a Bucket (Property)")
@Description(value={"Gets whether a living entity was previously in a bucket.\nCan be set and reset."})
@Examples(value={"send is from a bucket state of {_fish}"})
@Since(value={"1.3.8"})
@RequiredPlugins(value={"Paper 1.18+"})
public class ExprBucketableIsFromBucket
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        Bucketable bucketable;
        return from instanceof Bucketable && (bucketable = (Bucketable)from).isFromBucket();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)from;
            bucketable.setFromBucket(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "bucketable is from bucket";
    }

    static {
        if (Constants.PAPER_1_18) {
            ExprBucketableIsFromBucket.register(ExprBucketableIsFromBucket.class, Boolean.class, "[bucketable]", "[is] from [a] bucket", "livingentities");
        }
    }
}

