/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.bucketable.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import io.papermc.paper.entity.Bucketable;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Bucketable - Bucket Pickup Sound")
@Description(value={"Gets the sound that is played when the provided entity is picked up in a bucket."})
@Examples(value={"set {_sound} to bucket pickup sound of {_fish}"})
@Since(value={"1.3.8"})
@RequiredPlugins(value={"Paper 1.18+"})
public class ExprBucketablePickupSound
extends SimplerPropertyExpression<LivingEntity, Sound> {
    @Nullable
    public Sound convert(LivingEntity from) {
        Sound sound;
        if (from instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)from;
            sound = bucketable.getPickupSound();
        } else {
            sound = null;
        }
        return sound;
    }

    protected String getPropertyName() {
        return "bucket pickup sound";
    }

    public Class<? extends Sound> getReturnType() {
        return Sound.class;
    }

    static {
        if (Constants.PAPER_1_18) {
            ExprBucketablePickupSound.register(ExprBucketablePickupSound.class, Sound.class, (String)"bucket pickup sound", (String)"livingentities");
        }
    }
}

