/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.cat.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Cat;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Cat - is Lying Down")
@Description(value={"Checks if a cat is laying down."})
@Examples(value={"on damage of cat:\n\tif victim is laying down:\n\t\tcancel event"})
@Since(value={"1.0.3"})
@RequiredPlugins(value={"Paper 1.18.2+"})
public class CondCatIsLyingDown
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Cat cat;
        return entity instanceof Cat && (cat = (Cat)entity).isLyingDown();
    }

    @NotNull
    protected String getPropertyName() {
        return "lying down";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            CondCatIsLyingDown.register(CondCatIsLyingDown.class, (String)"lying down", (String)"livingentities");
        }
    }
}

