/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.cat.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Cat;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Cat - is Looking Up (Property)")
@Description(value={"Returns whether or not a cat is looking up.\nCan be set and reset."})
@Examples(value={"broadcast cat looking up state of target"})
@Since(value={"1.0.3, 1.3 (Plural, Reset)"})
@DocumentationId(value="11897")
@RequiredPlugins(value={"Paper"})
public class ExprCatIsLookingUp
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        Cat cat;
        return from instanceof Cat && (cat = (Cat)from).isHeadUp();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Cat) {
            Cat cat = (Cat)from;
            cat.setHeadUp(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "cat is looking up";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprCatIsLookingUp.register(ExprCatIsLookingUp.class, Boolean.class, "cat", "[is] looking up", "livingentities");
        }
    }
}

