/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.chicken.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Chicken - is Chicken Jockey (Property)")
@Description(value={"Checks if the provided chickens are chicken jockeys."})
@Examples(value={"set the is a chicken jockey property of {_chicken} to true"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper"})
public class ExprChickenJockey
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        Chicken chicken;
        return from instanceof Chicken && (chicken = (Chicken)from).isChickenJockey();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Chicken) {
            Chicken chicken = (Chicken)from;
            chicken.setIsChickenJockey(to.booleanValue());
        }
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "is a chicken jockey";
    }

    static {
        if (Constants.PAPER_1_19_2) {
            ExprChickenJockey.register(ExprChickenJockey.class, Boolean.class, (String)"[is] [a] chicken jockey", (String)"livingentities");
        }
    }
}

