/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.dolphin.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Dolphin - Has Been Fed Fish")
@Description(value={"Checks if a dolphin has a fish."})
@Examples(value={"on damage:\n\tif victim has a fish:\n\t\tbroadcast \"It has a fish!\""})
@Since(value={"1.0.3"})
@RequiredPlugins(value={"Paper 1.18.2+"})
public class CondDolphinBeenFedFish
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Dolphin dolphin;
        return entity instanceof Dolphin && (dolphin = (Dolphin)entity).hasFish();
    }

    @NotNull
    protected String getPropertyName() {
        return "been fed fish";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            CondDolphinBeenFedFish.register(CondDolphinBeenFedFish.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"been fed [a] fish", (String)"livingentities");
        }
    }
}

