/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.dolphin.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Dolphin - Has Been Fish (Property)")
@Description(value={"Returns whether or not the provided dolphins have been fed a fish.\nCan be set."})
@Examples(value={"broadcast has fish state of target"})
@Since(value={"1.0.3, 1.3 (Plural)"})
@RequiredPlugins(value={"Paper"})
public class ExprDolphinHasFishState
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        Dolphin dolphin;
        return from instanceof Dolphin && (dolphin = (Dolphin)from).hasFish();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)from;
            dolphin.setHasFish(to.booleanValue());
        }
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "has been fed a fish";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprDolphinHasFishState.register(ExprDolphinHasFishState.class, Boolean.class, "[dolphin]", "[has] been fed [a] fish", "livingentities");
        }
    }
}

