/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.dolphin.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Dolphin - Moisture Level")
@Description(value={"Returns the moisture level of the provided dolphins.\nCan be set, added to, and removed from."})
@Examples(value={"broadcast moisture of target"})
@Since(value={"1.0.3, 1.3 (Plural, Add, Remove)"})
@RequiredPlugins(value={"Paper"})
public class ExprDolphinMoisture
extends SimplerPropertyExpression<LivingEntity, Integer> {
    @Nullable
    public Integer convert(LivingEntity from) {
        Integer n;
        if (from instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)from;
            n = dolphin.getMoistness();
        } else {
            n = null;
        }
        return n;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowAdd() {
        return true;
    }

    @Override
    public boolean allowRemove() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Integer to) {
        if (from instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)from;
            dolphin.setMoistness(to.intValue());
        }
    }

    @Override
    public void add(LivingEntity from, Integer to) {
        if (from instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)from;
            dolphin.setMoistness(dolphin.getMoistness() + to);
        }
    }

    @Override
    public void remove(LivingEntity from, Integer to) {
        if (from instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)from;
            dolphin.setMoistness(dolphin.getMoistness() - to);
        }
    }

    protected String getPropertyName() {
        return "dolphin moisture level";
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprDolphinMoisture.register(ExprDolphinMoisture.class, Integer.class, (String)"dolphin moist(ure [level|amount]|ness [amount])", (String)"livingentities");
        }
    }
}

