/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.enderdragon.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.EnderDragon;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Ender Dragon Phase")
@Description(value={"Returns the Ender Dragon phase in an Ender Dragon Phase Change Event.\nCan be set. (Setting will always change the NEW phase)"})
@Examples(value={"on ender dragon phase change:\n\tbroadcast the current ender dragon phase"})
@Since(value={"1.0.2"})
public class ExprEnderDragonPhase
extends SimpleExpression<EnderDragon.Phase> {
    private boolean current;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(EnderDragonChangePhaseEvent.class)) {
            Skript.error((String)"This expression can only be used in the Ender Dragon Phase Change Event!");
            return false;
        }
        this.current = parseResult.hasTag("current");
        return true;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    EnderDragon.Phase @NotNull [] get(@NotNull Event e) {
        EnderDragonChangePhaseEvent event = (EnderDragonChangePhaseEvent)e;
        EnderDragon.Phase phase = this.current ? event.getCurrentPhase() : event.getNewPhase();
        return new EnderDragon.Phase[]{phase};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = EnderDragon.Phase.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof EnderDragon.Phase) {
            EnderDragon.Phase phase = (EnderDragon.Phase)object;
            ((EnderDragonChangePhaseEvent)e).setNewPhase(phase);
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends EnderDragon.Phase> getReturnType() {
        return EnderDragon.Phase.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + (this.current ? "current" : "new") + " ender dragon phase";
    }

    static {
        Skript.registerExpression(ExprEnderDragonPhase.class, EnderDragon.Phase.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"(the |event-)[new|:current] ender[ ]dragon phase"});
    }
}

