/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.enderman.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Enderman - Has Been Stared At")
@Description(value={"Checks if an enderman has been stared at."})
@Examples(value={"if target has been stared at:"})
@Since(value={"1.0.2"})
@DocumentationId(value="9021")
@RequiredPlugins(value={"Paper 1.18.2+"})
public class CondEndermanHasBeenStaredAt
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Enderman enderman;
        return entity instanceof Enderman && (enderman = (Enderman)entity).hasBeenStaredAt();
    }

    @NotNull
    protected String getPropertyName() {
        return "been stared at";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            CondEndermanHasBeenStaredAt.register(CondEndermanHasBeenStaredAt.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"been stared at", (String)"livingentities");
        }
    }
}

