/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.enderman.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.paperlib.PaperLib;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enderman - Randomly Teleport")
@Description(value={"Attempts to teleport an enderman to a random nearby location.\nRequires Spigot 1.20.1+ or Paper, behavior might be slightly different."})
@Examples(value={"randomly teleport {_endermen::*}"})
@Since(value={"1.0.2, 1.3 (Spigot)"})
@RequiredPlugins(value={"Paper or 1.20.1+"})
@DocumentationId(value="9044")
public class EffEndermanRandomTeleport
extends Effect {
    private Expression<LivingEntity> entityExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.entityExpression = expressions[0];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "attempt to randomly teleport " + this.entityExpression.toString(event, debug);
    }

    protected void execute(@NotNull Event event) {
        for (LivingEntity entity : (LivingEntity[])this.entityExpression.getArray(event)) {
            if (!(entity instanceof Enderman)) continue;
            Enderman enderman = (Enderman)entity;
            if (PaperLib.isPaper()) {
                enderman.teleportRandomly();
                continue;
            }
            if (!Constants.MINECRAFT_1_20_1) continue;
            enderman.teleport();
        }
    }

    static {
        if (PaperLib.isPaper() || Constants.MINECRAFT_1_20_1) {
            Skript.registerEffect(EffEndermanRandomTeleport.class, (String[])new String[]{"[attempt to] randomly teleport %livingentities%"});
        }
    }
}

