/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.enderman.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Enderman - Has Been Stared At (Property)")
@Description(value={"Returns whether or not an enderman has been stared at.\nCan be set."})
@Examples(value={"broadcast has been stared at state of target"})
@Since(value={"1.0.2"})
@RequiredPlugins(value={"Paper"})
public class ExprEndermanBeenStaredAt
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        Enderman enderman;
        return from instanceof Enderman && (enderman = (Enderman)from).hasBeenStaredAt();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Enderman) {
            Enderman enderman = (Enderman)from;
            enderman.setHasBeenStaredAt(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "has been stared at";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprEndermanBeenStaredAt.register(ExprEndermanBeenStaredAt.class, Boolean.class, "[enderman]", "[has] been (stared|looked) at", "livingentities");
        }
    }
}

