/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.enderman.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.slot.Slot;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enderman - Held Block Data")
@Description(value={"Returns the Held Block Data of the provided Endermen."})
@Examples(value={"broadcast carried blockdata of target"})
@Since(value={"1.0.2, 1.3 (Plural)"})
public class ExprEndermanHeldBlock
extends SimplerPropertyExpression<LivingEntity, BlockData> {
    @Nullable
    public BlockData convert(LivingEntity from) {
        if (from instanceof Enderman) {
            Enderman enderman = (Enderman)from;
            return enderman.getCarriedBlock();
        }
        return null;
    }

    protected String getPropertyName() {
        return "enderman carried block data";
    }

    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    @Override
    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: 
            case RESET: 
            case DELETE: {
                Class[] classArray2 = new Class[5];
                classArray2[0] = Block.class;
                classArray2[1] = BlockData.class;
                classArray2[2] = Slot.class;
                classArray2[3] = ItemStack.class;
                classArray = classArray2;
                classArray2[4] = ItemType.class;
                break;
            }
            default: {
                classArray = null;
            }
        }
        return classArray;
    }

    @Override
    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        for (LivingEntity livingEntity : (LivingEntity[])this.getExpr().getAll(e)) {
            if (!(livingEntity instanceof Enderman)) continue;
            Enderman enderman = (Enderman)livingEntity;
            if (mode == Changer.ChangeMode.SET) {
                Material material;
                Slot slot;
                ItemStack itemStack;
                Object o = delta[0];
                if (o instanceof BlockData) {
                    BlockData blockData1 = (BlockData)o;
                    enderman.setCarriedBlock(blockData1);
                    continue;
                }
                if (o instanceof Block) {
                    Block block = (Block)o;
                    enderman.setCarriedBlock(block.getBlockData());
                    continue;
                }
                if (o instanceof ItemType) {
                    ItemType itemType = (ItemType)o;
                    if (!itemType.getMaterial().isBlock()) continue;
                    enderman.setCarriedBlock(Bukkit.createBlockData((Material)itemType.getMaterial()));
                    continue;
                }
                if (o instanceof ItemStack) {
                    ItemStack itemStack2 = (ItemStack)o;
                    Material material2 = itemStack2.getType();
                    if (!material2.isBlock()) continue;
                    enderman.setCarriedBlock(Bukkit.createBlockData((Material)material2));
                    continue;
                }
                if (!(o instanceof Slot) || (itemStack = (slot = (Slot)o).getItem()) == null || !(material = itemStack.getType()).isBlock()) continue;
                enderman.setCarriedBlock(Bukkit.createBlockData((Material)material));
                continue;
            }
            enderman.setCarriedBlock(null);
        }
    }

    static {
        ExprEndermanHeldBlock.register(ExprEndermanHeldBlock.class, BlockData.class, (String)"[enderman] (held|carried) block[ |-]data", (String)"livingentities");
    }
}

