/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endersignal.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Ender Signal - is Going to Drop/Shatter (Property)")
@Description(value={"Gets the item the provided ender signals will display and drop on death.\n"})
@Examples(value={"send ender signal will drop property of {_enderSignal}"})
@Since(value={"1.3"})
public class ExprEnderSignalItemDrop
extends SimpleBooleanPropertyExpression<Entity> {
    @Override
    public boolean setNegated(int matchedPattern, SkriptParser.ParseResult parseResult) {
        return parseResult.hasTag("shatter");
    }

    @Nullable
    public Boolean convert(Entity from) {
        EnderSignal enderSignal;
        return from instanceof EnderSignal && (enderSignal = (EnderSignal)from).getDropItem() ^ this.isNegated();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(Entity from, Boolean to) {
        if (from instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)from;
            enderSignal.setDropItem(to.booleanValue());
        }
    }

    protected String getPropertyName() {
        return "ender signal will " + (this.isNegated() ? "shatter" : "drop");
    }

    static {
        ExprEnderSignalItemDrop.register(ExprEnderSignalItemDrop.class, Boolean.class, "ender (signal|eye)", "[will|is going to] (drop|:shatter)", "entities");
    }
}

