/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Angry")
@Description(value={"Checks if an entity is angry.\n(Warden, PigZombie, Wolf, Enderman)"})
@Examples(value={"on damage of wolf:\n\tif victim is angry:\n\t\tcancel event"})
@Since(value={"1.0.2"})
public class CondEntityAngry
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return EntityUtils.isAngry(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "angry";
    }

    static {
        CondEntityAngry.register(CondEntityAngry.class, (String)"angry", (String)"livingentities");
    }
}

