/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - Can Breathe Underwater")
@Description(value={"Checks if the provided living entities can breathe underwater and will not take suffocation damage when their air supply reaches zero."})
@Examples(value={"if {_entity} can breathe underwater:"})
@Since(value={"1.0.2"})
@DocumentationId(value="11180")
public class CondEntityCanBreatheUnderwater
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return entity.canBreatheUnderwater();
    }

    @NotNull
    protected String getPropertyName() {
        return "breathe underwater";
    }

    static {
        CondEntityCanBreatheUnderwater.register(CondEntityCanBreatheUnderwater.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.CAN, (String)"breathe underwater", (String)"livingentities");
    }
}

