/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Aggressive")
@Description(value={"Checks if the provided entities are aggressive.\n\nSome mobs will raise their arm(s) when aggressive:\nDrowned, Piglin, Skeleton, Zombie, ZombieVillager, Illusioner, Vindicator, Panda, Pillager, PiglinBrute\n\nNote: This doesn't always return the actual aggressive state as when set, Pandas are always aggressive if their combined Panda Gene is AGGRESSIVE.\n"})
@Examples(value={"on damage of wolf:\n\tif victim is angry:\n\t\tcancel event"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper 1.20.2"})
public class CondEntityIsAggressive
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Mob mob;
        return entity instanceof Mob && (mob = (Mob)entity).isAggressive();
    }

    @NotNull
    protected String getPropertyName() {
        return "aggressive";
    }

    static {
        if (Constants.MINECRAFT_1_20_2) {
            CondEntityIsAggressive.register(CondEntityIsAggressive.class, (String)"aggressive", (String)"livingentities");
        }
    }
}

