/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Dancing")
@Description(value={"Checks if an entity is dancing.\n(Parrot, Allay, Piglin)"})
@Examples(value={"on damage of parrot:\n\tif victim is dancing:\n\t\tcancel event\n\t\tbroadcast \"The vibe won't stop!\""})
@Since(value={"1.0.2, 1.1 (Piglin)"})
@DocumentationId(value="11183")
public class CondEntityIsDancing
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return EntityUtils.isDancing(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "dancing";
    }

    static {
        CondEntityIsDancing.register(CondEntityIsDancing.class, (String)"dancing", (String)"livingentities");
    }
}

