/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Screaming")
@Description(value={"Checks if an entity is screaming.\n(Goat, Enderman when using Paper 1.18.2+)"})
@Examples(value={"on damage of enderman:\n\tif victim is screaming:\n\t\tcancel event"})
@Since(value={"1.0.2"})
public class CondEntityIsScreaming
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return EntityUtils.isScreaming(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "screaming";
    }

    static {
        CondEntityIsScreaming.register(CondEntityIsScreaming.class, (String)"screaming", (String)"livingentities");
    }
}

