/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Animal - is Sitting")
@Description(value={"Checks if an entity is sitting.\n(Camels, Cats, Wolves, Parrots, Pandas and Foxes)"})
@Examples(value={"on damage of wolf, cat or fox:\n\tif victim is sitting:\n\t\tcancel event"})
@Since(value={"1.0.0"})
@DocumentationId(value="8789")
public class CondEntityIsSitting
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return EntityUtils.isSitting((Entity)entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "sitting";
    }

    static {
        CondEntityIsSitting.register(CondEntityIsSitting.class, (String)"s(at [down]|it[ting [down]])", (String)"livingentities");
    }
}

