/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Shoot - Bow/Item")
@Description(value={"Returns whether or not the consumable item should be consumed in the Entity Shoot Event."})
@Examples(value={"on entity shoot:\n\tif the shot item should be consumed:\n\t\tbroadcast the consumed item"})
@Since(value={"1.1.1"})
public class CondEntityShootConsumeItem
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(EntityShootBowEvent.class)) {
            Skript.error((String)"This expression can only be used in the Entity Shoot event!");
            return false;
        }
        this.setNegated(parser.hasTag("not"));
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the shot item should " + (this.isNegated() ? "not" : "") + " be consumed";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ ((EntityShootBowEvent)event).shouldConsumeItem();
    }

    static {
        Skript.registerCondition(CondEntityShootConsumeItem.class, (String[])new String[]{"[the] (shot|launched) item should[not:( not|n't)] be consumed"});
    }
}

