/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Bat;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Sleeping")
@Description(value={"Checks if one or more living entities are awake or sleeping."})
@Examples(value={"on damage:\n\tcancel event if victim is sleeping"})
@Since(value={"1.0.0, 1.2 (Sleeping, Asleep)"})
public class CondEntitySleeping
extends PropertyCondition<LivingEntity> {
    boolean awake;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.awake = parseResult.hasTag("awake");
        return true;
    }

    public boolean check(LivingEntity entity) {
        Bat bat;
        boolean sleeping = entity instanceof Bat ? !(bat = (Bat)entity).isAwake() : entity.isSleeping();
        return this.awake ^ sleeping;
    }

    @NotNull
    protected String getPropertyName() {
        return this.awake ? "awake" : "sleeping";
    }

    static {
        CondEntitySleeping.register(CondEntitySleeping.class, (String)"(:awake|asleep|sleeping)", (String)"livingentities");
    }
}

