/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.events;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import io.papermc.paper.event.player.PlayerNameEntityEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import java.util.Arrays;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtEntityRename
extends SkriptEvent {
    @Nullable
    private EntityData<?>[] types = new EntityData[0];

    public boolean init(Literal @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        if (args.length > 0) {
            this.types = args[0] == null ? null : (EntityData[])args[0].getAll();
        }
        return true;
    }

    public boolean check(@NotNull Event e) {
        if (this.types == null) {
            return true;
        }
        @NotNull EntityType entity = ((PlayerNameEntityEvent)e).getEntity().getType();
        for (EntityData<?> type : this.types) {
            if (type == null || entity != EntityUtils.toBukkitEntityType(type)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "entity rename" + (String)(this.types == null ? "" : " " + Arrays.toString(this.types));
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerNameEntityEvent")) {
            Skript.registerEvent((String)"Entity - on Rename", EvtEntityRename.class, PlayerNameEntityEvent.class, (String[])new String[]{"entity rename [of %-entitydatas%]", "[entity] %-entitydatas% renam(e[d]|ing)"}).description(new String[]{"Called when the player is attempting to rename a mob."}).examples(new String[]{"on entity rename of pig:\n  broadcast entity's display name"}).since("1.0.0").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(PlayerNameEntityEvent.class, Entity.class, PlayerNameEntityEvent::getEntity, 0);
        }
    }
}

